function Format-Number($n) {
    $prefix = @("", "k", "M", "G", "T", "P", "E", "Z", "Y")
    $index = 0
    while($n -ge 1024 -and $index -lt $prefix.Length - 1) {
        $n /= 1024
        $index += 1
    }
    return "{0:N2} {1}" -f $n, $prefix[$index]
}

function Raus {
        Write-Host "`r`n`r`n(Enter drcken zum Beenden)" -NoNewline
        Read-Host
        exit
}

$identity = [System.Security.Principal.WindowsIdentity]::GetCurrent()
$princ = New-Object System.Security.Principal.WindowsPrincipal($identity)
if(-not $princ.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Write-Host "Fehler: Dieses Skript muss mit Administratorrechten gestartet werden!"
    Raus
}

Clear-Host
Write-Host "`r`n            Willkommen beim Einrichtungsskript fr c't-WIMage!"
Write-Host "`r`nEs wird auf dem Laufwerk, von dem es gestartet wurde, eine weitere Partition anlegen und alles fr c't-WIMage Ntige darauf kopieren."


       

$myDriveLetter = ($MyInvocation.MyCommand.Definition).Substring(0, 1)
$myDriveName = (Get-Volume -DriveLetter $mydriveletter).FileSystemLabel
$myPart = Get-Partition -DriveLetter $myDriveLetter
$myDisk = Get-Disk -Partition $myPart
if ((get-volume -driveletter ${myDriveLetter}).drivetype -eq "Removable") {
    if ((Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\" -Name ReleaseID -ErrorAction SilentlyContinue).ReleaseId -lt 1703) {
        Write-Host "`r`nFehler: Ihre Windows-Version kann noch nicht mit mehreren Partitionen auf einem USB-Stick umgehen. Verwenden Sie eine USB-Fesplatte oder USB-SSD."
        Raus
        }
    }
$free = $myDisk.LargestFreeExtent
if($free -lt 3MB) {
    Write-Host "`r`nFehler: Auf dem Laufwerk ist kein unpartitionierter Platz mehr frei."
    Raus
}

if (-not (Test-Path -Path ${myDriveLetter}:\x64\sources)) {
     if (-not (Test-Path -Path ${myDriveLetter}:\sources)) {
         Write-Host "`r`nFehler: Keine fr c't-WIMage geeigneten Setup-Dateien auf dem Laufwerk gefunden."
         Write-Host "        Bitte lesen Sie die Anleitung in c't 10/2021!"
         Raus
    }
}

$message  = "`r`nAuf Datentrger $($myDisk.DiskNumber) (`"$($myDisk.FriendlyName)`" an $($myDisk.BusType); worauf auch "
$message += "Laufwerk ${myDriveletter}: (`"${mydrivename}`") liegt) wird ein neues, $(Format-Number $free)Byte groes Volume erstellt."
$message += "`r`n`r`nFortfahren?"
$choiceYes = New-Object System.Management.Automation.Host.ChoiceDescription "&Ja", "Ja: Partitionierung wie angegeben durchfhren"
$choiceNo = New-Object System.Management.Automation.Host.ChoiceDescription "&Nein", "Nein: Den Vorgang hier abbrechen"
$choices = [System.Management.Automation.Host.ChoiceDescription[]]($choiceYes, $choiceNo)
$confirm = $Host.UI.PromptForChoice("Los geht's", $message, $choices, 0)
if($confirm -ne 0) {
    Write-Host "`r`nAbbruch durch Benutzer"
    Raus
}

$newPart = $myDisk | New-Partition -UseMaximumSize -MbrType IFS
if($newPart) {
    $newVolume = $newPart | Format-Volume -FileSystem NTFS -NewFileSystemLabel 'CT-WIMAGE'
    if($newVolume) {
        # Den nchsten freien Laufwerksbuchstaben hinter dem aktuellen zuweisen
        $myDriveLetter = [char]($myDriveLetter.ToUpper())
        $newLetter = $myDriveLetter
        do {
            $newLetter = [char]([int]($newLetter) + 1)
            if($newLetter -gt [char]'Z') {
                # Nach 'Z' auch noch die Buchstaben ab 'C' durchprobieren
                $newLetter = [char]'C'
            }
            if($newLetter -eq $myDriveLetter) {
                # Alle Buchstaben probiert, keinen freien gefunden
                [system.windows.forms.messagebox]::show("`r`nDas Laufwerk wurde erstellt, aber es wurde kein freier Laufwerksbuchstabe gefunden.")
                exit
            }
            $testVolume = Get-Volume -DriveLetter $newLetter -ErrorAction SilentlyContinue
        } while ($testVolume)
        Start-Sleep -Seconds 1
        $newPart | Set-Partition -NewDriveLetter $newLetter
        Get-Volume -DriveLetter $myDriveLetter | Set-Volume -NewFileSystemLabel "ct-Boot"
        Write-Host "`r`nLaufwerk ${newLetter}: ($(Format-Number $newVolume.Size)Byte, `"$($newVolume.FileSystemLabel)`") wurde erfolgreich erstellt."
        Rename-Item -Path ${myDriveLetter}:\autorun.inf -NewName autorun.org -ErrorAction SilentlyContinue
    }
    else {
        Write-Host "`r`nFehler: Die neue Partition konnte nicht formatiert werden."
        Raus
    }
}
else {
    Write-Host "`r`nFehler: Partition konnte nicht erstellt werden."
    Raus
}

Write-Host "`r`nKopiere Dateien..."

function Copy-Wimage($Arch, $Pfad) {
    if(-not $Pfad) { $Pfad = $Arch + "\" }
    Copy-Item -Path "${myDriveLetter}:\${Pfad}sources" -Destination "${newLetter}:\${Pfad}sources" -Recurse -Exclude Boot.wim,install.esd
        # Sicher ist sicher: ltere PowerShell-Versionen missachten manchmal den -Exlude-Parameter
        ("Boot.wim","install.esd") | % { Remove-Item "${newLetter}:\${Pfad}sources\${_}" -ErrorAction SilentlyContinue }
    Rename-Item -path "${myDriveLetter}:\${Pfad}sources" -NewName sources.org
    New-Item -itemtype "directory" -path "${myDriveLetter}:\${Pfad}sources" | Out-Null
    Copy-Item -path "${myDriveLetter}:\${Pfad}sources.org\boot.wim" -destination "${myDriveLetter}:\${Pfad}sources\"
    Copy-Item -Path "${myDriveLetter}:\ct-WIMage\ct-WIMage.${Arch}" -Destination "${newLetter}:\${Pfad}ct-WIMage-${Arch}.bat"
    Copy-Item -Path "${myDriveLetter}:\ct-WIMage\vshadow.${Arch}" -Destination "${newLetter}:\${Pfad}sources\vshadow${Arch}.exe"
    Copy-Item -Path "${myDriveLetter}:\ct-WIMage\ct-WIMage.ini" -Destination "${newLetter}:\${Pfad}sources\ct-WIMage.ini"
    Copy-Item -Path "${myDriveLetter}:\ct-WIMage\ei.cfg" -Destination "${newLetter}:\${Pfad}sources\ei.cfg"
}

   
if (Test-Path -Path ${myDriveLetter}:\sources) {
    if( (Get-Content "${myDriveLetter}:\sources\idwbinfo.txt" -Raw) -match "BuildArch=(\w+)") {
        $archtemp = $Matches[1]
            if ($archtemp -eq "amd64") {
                $arch = "x64"
                }
                elseif ($archtemp -eq "x86") {
                $arch = "x86"
                }
            else {
                Write-Host "Fehler: Plattformkennung $archtemp der Installationsdateien auf Laufwerk ${myDriveLetter}: wird nicht untersttzt."
                Raus
                }
            }
    else {
        Write-Host "Fehler: Keine Plattformkennung auf Laufwerk ${myDriveLetter}: gefunden. Bitte lesen Sie die Anleitung in c't 10/2021!"
        Raus
    }
Copy-Wimage $arch "\"
}

if (Test-Path -Path ${myDriveLetter}:\x64\sources) {
    Copy-Wimage "x64"
    Copy-Wimage "x86"
    Copy-Item -Path "${myDriveLetter}:\ct-WIMage\ct-WIMage.start" -destination "${newLetter}:\ct-WIMage-x86+x64.bat"
    Copy-Item -Path "${myDriveLetter}:\ct-wimage\bcd.bios" -destination "${myDriveLetter}:\boot\bcd"
    Copy-Item -Path "${myDriveLetter}:\ct-wimage\bcd.uefi" -destination "${myDriveLetter}:\efi\microsoft\boot\bcd"
}

Write-Host "`r`n`r`nFertig!"
Raus